% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{is_from}
\alias{is_from}
\title{Test whether an object is considered to be from a particular database}
\usage{
is_from(x, db, ...)
}
\arguments{
\item{x}{An object to test.}

\item{db}{The database to test against.}

\item{...}{Any arguments to be passed to the underlying functions (unused).}
}
\value{
Whether the data is from a given database (as a boolean).
}
\description{
This function tests whether an object is considered (by \code{ohvbd}) to be from a given database.

This is a fairly coarse check, and so cannot "work out" data provenance from its structure.
}
\examples{
ids <- ohvbd.ids(c(1,2,3), "vd")
is_from(ids, "vd")

}
\author{
Francis Windram
}
\concept{convenience}
