% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{plot_met_data_summary}
\alias{plot_met_data_summary}
\title{Plot and Analyze Metabolomics Data Summary}
\usage{
plot_met_data_summary(
  file_path,
  output_xlsx = "internal_standards.xlsx",
  is_plots_dir = "is_plots",
  blank_pattern = "Blank|Control|Neg",
  pooled_pattern = "Pooled QC|Pooled|Pool|PQ",
  nist_pattern = "NIST Plasma|NIST|nist",
  other_special_pattern = "Special Case|Extra Sample|Other QC"
)
}
\arguments{
\item{file_path}{The path to the metabolomics measurement data file (e.g., "area_TM.txt").}

\item{output_xlsx}{The path where the Excel file with internal standards will be saved (default is "internal_standards.xlsx").}

\item{is_plots_dir}{Directory where plots for each internal standard will be saved (default is "is_plots").}

\item{blank_pattern}{Pattern for identifying blank samples in `Sample ID` column (default is "Blank|BLANK|blank|Control|Negative Control|Neg Control|BLK|Blk").}

\item{pooled_pattern}{Pattern for identifying pooled QC samples in `Sample ID` column (default is "Pooled QC|Pooled_QC|Pooled|POOL|Pool|pool|QC Mix|Mix QC|Pool QC|PQ|PQC").}

\item{nist_pattern}{Pattern for identifying NIST QC samples in `Sample ID` column (default is "NIST Plasma|NIST_Plasma|NIST-QC|Reference Plasma|Plasma Ref|NIST_QC|NIST QC|NIST|nist").}

\item{other_special_pattern}{Pattern for identifying other special cases in `Sample ID` column (default is "Special Case|Extra Sample|NonStandard QC|Other QC").}
}
\value{
Saves internal standard plots and an Excel file with the identified internal standards.
}
\description{
This function loads a specified data file containing metabolomics measurements, identifies internal standards based on a naming convention,
and generates plots for the distribution of internal standards across samples. It also saves the internal standard information in an Excel file.
}
\author{
Yaoxiang Li
}
