% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{int2col}
\alias{int2col}
\title{Convert integers to spreadsheet column notation}
\usage{
int2col(x)
}
\arguments{
\item{x}{A numeric vector representing the column indices to be converted.}
}
\value{
A character vector of spreadsheet column labels. Returns \code{NULL}
if the input \code{x} is \code{NULL}.
}
\description{
\code{int2col()} performs the inverse operation of \code{\link[=col2int]{col2int()}}, transforming numeric
column indices into their corresponding spreadsheet-style character labels
(e.g., 1 to "A", 28 to "AB"). This is essential for converting calculated
indices back into a format compatible with spreadsheet cell referencing.
}
\details{
The function accepts a numeric vector and maps each integer to its positional
representation in a base-26 derived system. This mapping follows standard
spreadsheet conventions where the sequence progresses from "A" through "Z",
followed by "AA", "AB", and so forth.

Validation is performed to ensure the input is numeric and finite. In accordance
with the Office Open XML specification used by most spreadsheet software, the
maximum supported column index is 16,384, which corresponds to the column
label "XFD". Inputs exceeding this range may result in coordinates that are
incompatible with standard spreadsheet applications.
}
\section{Notes}{

\itemize{
\item Non-integer numeric values will typically be coerced or truncated; however,
infinite values will trigger an error to prevent invalid coordinate
generation.
}
}

\examples{
# Convert a single index
int2col(27)

# Convert a sequence of indices
int2col(1:10)

# Handle large column indices
int2col(c(702, 703, 16384))

}
\seealso{
\code{\link[=col2int]{col2int()}}
}
