% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_ignore_error}
\alias{wb_add_ignore_error}
\title{Ignore error types on a worksheet}
\usage{
wb_add_ignore_error(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  calculated_column = FALSE,
  empty_cell_reference = FALSE,
  eval_error = FALSE,
  formula = FALSE,
  formula_range = FALSE,
  list_data_validation = FALSE,
  number_stored_as_text = FALSE,
  two_digit_text_year = FALSE,
  unlocked_formula = FALSE,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{dims}{A character string defining the cell range (e.g., "A1:A100").}

\item{calculated_column}{Logical; if \code{TRUE}, ignores errors in
calculated columns of a table.}

\item{empty_cell_reference}{Logical; if \code{TRUE}, ignores errors when a
formula refers to an empty cell.}

\item{eval_error}{Logical; if \code{TRUE}, ignores errors resulting from
formula evaluation (e.g., \verb{#DIV/0!}, \verb{#N/A}).}

\item{formula}{Logical; if \code{TRUE}, ignores formula consistency errors.}

\item{formula_range}{Logical; if \code{TRUE}, ignores errors where a formula
omits cells in a region.}

\item{list_data_validation}{Logical; if \code{TRUE}, ignores errors related to
list data validation mapping.}

\item{number_stored_as_text}{Logical; if \code{TRUE}, suppresses the error
displayed when numeric values are stored as string/text types.}

\item{two_digit_text_year}{Logical; if \code{TRUE}, ignores warnings about
dates containing two-digit years.}

\item{unlocked_formula}{Logical; if \code{TRUE}, ignores errors for formulas
in cells that are not locked.}

\item{...}{Additional arguments.}
}
\value{
The \link{wbWorkbook} object, invisibly.
}
\description{
The \code{wb_add_ignore_error()} function allows you to suppress specific types of
background error checking warnings for a given cell range. This is useful for
preventing the display of green error indicators (triangles) in cases where
"errors" are intentional, such as numbers being stored as text for
formatting purposes.
}
\details{
Spreadsheet software performs background validation on formulas and data
entries. When a cell triggers a rule, a visual indicator appears. This
function modifies the \verb{<ignoredErrors>} section of the worksheet XML to
whitelist specific ranges against specific rules.

Most commonly, this is used with \code{number_stored_as_text = TRUE} when
IDs or codes (like "00123") must be preserved as character strings but
contain only numeric digits.
}
\section{Notes}{

\itemize{
\item This function does not fix the underlying data; it only instructs the
spreadsheet application not to flag the specific error type visually.
\item If multiple error types need to be ignored for the same range, you can
set multiple arguments to \code{TRUE} in a single call.
}
}

