% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_page_break}
\alias{wb_add_page_break}
\title{Add a page break to a worksheet}
\usage{
wb_add_page_break(wb, sheet = current_sheet(), row = NULL, col = NULL)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{row}{Integer; the row number where the horizontal page break should
be inserted.}

\item{col}{Integer or character; the column number or name (e.g., "B")
where the vertical page break should be inserted.}
}
\value{
The \link{wbWorkbook} object, invisibly.
}
\description{
The \code{wb_add_page_break()} function allows you to manually insert horizontal
or vertical page breaks into a worksheet. These breaks determine where the
spreadsheet software starts a new page when printing or generating a PDF.
}
\details{
Manual page breaks override the automatic breaks calculated by the software
based on margins and paper size.
\itemize{
\item Row Breaks: When a \code{row} is specified, the horizontal break is placed
\emph{above} the specified row. For example, setting \code{row = 10} ensures that
Row 10 starts on a new page.
\item Column Breaks: When a \code{col} is specified, the vertical break is placed
to the \emph{left} of that column. For example, \code{col = "B"} (or \code{2}) ensures
Column B is the first column on the next vertical page.
}

You must provide either a \code{row} or a \code{col} index, but not both in a single
call. To create a page intersection (both horizontal and vertical), call
the function twice.
}
\section{Notes}{

\itemize{
\item Manual breaks are visible in "Page Break Preview" mode within most
spreadsheet applications.
}
}

\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_data(sheet = 1, x = iris)

wb$add_page_break(sheet = 1, row = 10)
wb$add_page_break(sheet = 1, row = 20)
wb$add_page_break(sheet = 1, col = 2)
}
\seealso{
\code{\link[=wb_add_worksheet]{wb_add_worksheet()}}
}
