% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-color.R
\name{wb_color}
\alias{wb_color}
\alias{wb_colour}
\title{Create a color object for workbook styling}
\usage{
wb_color(
  name = NULL,
  auto = NULL,
  indexed = NULL,
  hex = NULL,
  theme = NULL,
  tint = NULL,
  format = c("ARGB", "RGBA")
)
}
\arguments{
\item{name}{A character string. Can be a standard R color name (e.g., \code{"red"},
\code{"steelblue"}) or a hex value.}

\item{auto}{A logical value. If \code{TRUE}, the spreadsheet application
determines the color automatically (usually for text contrast).}

\item{indexed}{An integer referencing a legacy indexed color value.}

\item{hex}{A character string representing a hex color (e.g., \code{"FF0000"}).
Leading "#" is optional.}

\item{theme}{A zero-based integer index referencing a value in the
workbook's theme (usually 0-11).}

\item{tint}{A numeric value between -1.0 (darkest) and 1.0 (lightest)
to modify the base color.}

\item{format}{The alpha channel format for hex strings: \code{"ARGB"} (default)
or \code{"RGBA"}.}
}
\value{
A \code{wbColour} object (a named character vector).
}
\description{
\code{wb_color()} is a helper function used to define colors for fonts, fills,
borders, and other styling elements. It creates a \code{wbColour} object that
encapsulates color information in a format compatible with the OpenXML
specification.
}
\details{
Colors in spreadsheets can be defined in several ways. This function
standardizes those inputs into a single object.

Hex Color Formats:
Hexadecimal colors represent the intensity of Red, Green, and Blue.
A major point of confusion is the Alpha (transparency) channel:
\itemize{
\item ARGB (Default): Spreadsheet software expects the Alpha value before
the RGB values (e.g., \code{FFFF0000} for solid red).
\item RGBA: R functions like \code{\link[grDevices:adjustcolor]{grDevices::adjustcolor()}} place the Alpha
value after the RGB values (e.g., \code{FF0000FF} for solid red).
\item Use the \code{format} argument to tell \code{wb_color()} how to interpret your hex
string if it includes transparency.
}

Theme Colors:
Instead of hard-coding a hex value, you can use \code{theme}. These are indices
(0-based) referencing the workbook's theme palette (e.g., "Text 1", "Accent 1").
Using theme colors allows the spreadsheet's appearance to change
automatically if the user changes the workbook theme.

Tints:
The \code{tint} parameter modifies a color's lightness. A value of \code{-0.25}
darkens the color by 25\%, while \code{0.5} lightens it by 50\%.
}
\examples{
# Using standard R colors
font_col <- wb_color("darkblue")

# Using Hex values with Alpha
bg_col <- wb_color(hex = "FFED7D31") # ARGB for orange

# Using Theme colors with a tint (4th accent color, 40\% lighter)
theme_col <- wb_color(theme = 4, tint = 0.4)

# Converting R-style RGBA to spreadsheet-style ARGB
r_col <- adjustcolor("red", alpha.f = 0.5)
xlsx_col <- wb_color(hex = r_col, format = "RGBA")

}
\seealso{
\code{\link[=wb_get_base_colors]{wb_get_base_colors()}}, \code{\link[grDevices:colors]{grDevices::colors()}}
}
