% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-peer-reviews.R
\name{orcid_peer_reviews}
\alias{orcid_peer_reviews}
\title{Retrieve peer review activities from ORCID}
\usage{
orcid_peer_reviews(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.
Most public data is accessible without authentication.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this peer review record}
\item{reviewer_role}{Role of the reviewer (e.g., reviewer, editor)}
\item{review_type}{Type of review (e.g., review, evaluation)}
\item{review_completion_date}{Date the review was completed (ISO format)}
\item{organization}{Name of the convening organization (e.g., journal, conference)}
}
Returns an empty data.table with the same structure if no peer review
records are found.
}
\description{
Fetches peer review records for a given ORCID identifier from the ORCID
public API. Returns a structured data.table with peer review activities
including reviewer roles, review types, and organizations.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/peer-reviews}

Peer review activities can include journal article reviews, conference paper
reviews, grant reviews, and other forms of scholarly evaluation.

The function respects ORCID API rate limits and includes appropriate
User-Agent headers identifying the orcidtr package.
}
\examples{
\dontrun{
# Fetch peer review records for a public ORCID
reviews <- orcid_peer_reviews("0000-0002-1825-0097")
print(reviews)

# With authentication
Sys.setenv(ORCID_TOKEN = "your-token-here")
reviews <- orcid_peer_reviews("0000-0002-1825-0097")
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_works}}, \code{\link{orcid_funding}}, \code{\link{orcid_fetch_record}}
}
