% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{orderly_comparison_explain}
\alias{orderly_comparison_explain}
\title{Print the details of a packet comparison.}
\usage{
orderly_comparison_explain(cmp, attributes = NULL, verbose = FALSE)
}
\arguments{
\item{cmp}{An orderly_comparison object, as returned by
\code{\link[=orderly_compare_packets]{orderly_compare_packets()}}.}

\item{attributes}{A character vector of attributes to include in the
comparison. The values are keys of the packets' metadata, such as
\code{parameters} or \code{files}. If NULL, the default, all attributes are compared,
except those that differ in trivial way (i.e., \code{id} and \code{time}).}

\item{verbose}{Control over how much information is printed. It can either
be a logical, or a character scalar \code{silent} or \code{summary}.}
}
\value{
Invisibly, a logical indicating whether the packets are equivalent,
up to the given attributes.
}
\description{
This function allows to select what part of the packet to compare, and in
how much details.
}
\examples{
path <- orderly_example()
id1 <- orderly_run("parameters", list(max_cyl = 6), root = path)
id2 <- orderly_run("parameters", list(max_cyl = 4), root = path)
cmp <- orderly_compare_packets(id1, id2, root = path)

orderly_comparison_explain(cmp)
orderly_comparison_explain(cmp, verbose = TRUE)
orderly_comparison_explain(cmp, "parameters", verbose = TRUE)
}
