% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-inclusion-dates.R
\name{create_inclusion_dates}
\alias{create_inclusion_dates}
\title{Create inclusion dates from all the inclusion events}
\usage{
create_inclusion_dates(inclusions, stable_inclusion_start_date = "1998-01-01")
}
\arguments{
\item{inclusions}{Output from \code{\link[=join_inclusions]{join_inclusions()}}.}

\item{stable_inclusion_start_date}{Cutoff date after which inclusion events
are considered reliable (e.g., after changes in drug labeling or data
entry practices). Defaults to "1998-01-01" which is one year after
obstetric codes are reliable in the GLD data (since we use LPR data to
drop rows related to gestational diabetes). This limits the included
cohort to individuals with inclusion dates after this cutoff date.}
}
\value{
The same type as the input data, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}},
with the \code{pnr} and \code{date} columns along with the columns from the input
that's needed to classify T1D.
It also creates two new columns:
\itemize{
\item \code{raw_inclusion_date}: Date of raw inclusion, the second earliest recorded
event for each individual.
\item \code{stable_inclusion_date}: Same as raw inclusion date, but set to \code{NA} if
the raw inclusion date is before the stable inclusion start date.
}
}
\description{
This function takes the output from
\code{\link[=join_inclusions]{join_inclusions()}} and defines the final inclusion dates, raw and stable
based on all inclusion event types. Since inclusion requires at least two
events (can be multiple events of the same type or any combination of
different types), this function keeps only those with 2 or more events. E.g.,
an individual with two elevated HbA1c tests followed by a glucose-lowering
drug purchase is included at the latest elevated HbA1c test. Had the second
HbA1c test not been performed (or had it returned a result below the
diagnostic threshold), this person would instead have been included at the
date of the first purchase of glucose-lowering drugs.
}
\keyword{internal}
