% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{vis_2_params}
\alias{vis_2_params}
\title{Visualise the distribution of two parameters}
\usage{
vis_2_params(
  df,
  param_1,
  param_2,
  slope = NULL,
  intercept = 0,
  check = NULL,
  fit = NULL
)
}
\arguments{
\item{df}{a dataframe.}

\item{param_1}{character. Name of variable of the dataframe to be plotted on the x-axis.}

\item{param_2}{character. Name of variable of the dataframe to be plotted on the y-axis.}

\item{slope}{numeric. Default is NULL. If different than 0, plots a linear line with a user-defined intercept and the defined slope.}

\item{intercept}{numeric. Default is 0. Intercept of the user-defined slope.}

\item{check}{character. Default is NULL. When set to "param_2 > param_1". The dots fulfilling the condition are coloured in red.}

\item{fit}{character. Designate the type of smooth model to fit to the relation of `param_1` (x) and `param_2` (y). It can take the values "lm, "glm", "gam", and "loess". A model will be fitted according to the methods described in \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}.}
}
\value{
A ggplot graph.
}
\description{
This function plots the distribution of two parameters in a scatterplot.
}
\examples{
# Generating plot for the costs of progression-free health state versus incremental costs
data(df_pa)
vis_2_params(df = df_pa, param_1 = "c_pfs", "inc_costs")
}
