% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield_monitor.R
\name{pa_adjust_obs_effective_area}
\alias{pa_adjust_obs_effective_area}
\title{Adjust the effective area of each observation
  based on vehicular polygon overlap}
\usage{
pa_adjust_obs_effective_area(
  polygons,
  obs.vector,
  var.label = "yield",
  overlap.threshold = 0,
  cores = 1L,
  verbose = FALSE
)
}
\arguments{
\item{polygons}{sf object containing vehicular polygons}

\item{obs.vector}{a vector containing the observations}

\item{var.label}{a string used to label the columns
(e.g., yield)}

\item{overlap.threshold}{a fraction threshold to remove
observations. A value of 0 does not remove any
observations. A value of 1 removes all observations
that overlap even minimally with neighboring
observations.}

\item{cores}{the number of cores used in the operation}

\item{verbose}{whether to print operation details}
}
\value{
an sf object
}
\description{
Adjust the effective area of each
  observation based on vehicular polygon overlap
}
\details{
This function will make use of the vehicular
  polygons to evaluate the overlap between polygons and
  adjust the variable in obs.vector to the effective area
  in the polygon. This is primarely intended for yield.
}
