% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platt.R
\name{platt_modified}
\alias{platt_modified}
\title{Platt Model Modification}
\usage{
platt_modified(model_result)
}
\arguments{
\item{model_result}{A list containing the model result (e.g. from platt_generate_regression_ETR_II()).}
}
\value{
A modified model result as a list with the following elements:
\itemize{
  \item \code{etr_type}: ETR Type based on the model result.
  \item \code{etr_regression_data}: Regression data with ETR predictions based on the fitted model.
  \item \code{residual_sum_of_squares}: Difference between observed and predicted ETR values, expressed as the sum of squared residuals.
  \item \code{root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the root mean squared error.
  \item \code{relative_root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the relative root mean squared error, normalized by the mean.
  \item \code{a}: Obtained parameter \code{a}, equal to \code{etrmax_without_photoinhibition}.
  \item \code{b}: Obtained parameter \code{b}, equal to \code{alpha}.
  \item \code{c}: Obtained parameter \code{c}, equal to \code{beta}.
  \item \code{d}: Not available, set to \code{NA_real_}.
  \item \code{alpha}: The initial slope of the light curve, transferred unchanged as \code{alpha}.
  \item \code{beta}: The photoinhibition of the light curve, transferred unchanged as \code{beta}.
  \item \code{etrmax_with_photoinhibition}: The maximum electron transport rate with photoinhibition, transferred as \code{pm}.
  \item \code{etrmax_without_photoinhibition}: The maximum electron transport rate without photoinhibition, transferred as \code{ps}.
  \item \code{ik_with_photoinhibition}: PAR where the transition point from light limitation to light saturation is achieved with photoinhibition, transferred as \code{ik}.
  \item \code{ik_without_photoinhibition}: PAR where the transition point from light limitation to light saturation is achieved without photoinhibition, transferred as \code{is}.
  \item \code{im_with_photoinhibition}: The PAR at which the maximum electron transport rate is achieved with photoinhibition, transferred as \code{im}.
  \item \code{w}: Not available, set to \code{NA_real_}.
  \item \code{ib}: Transferred unchanged as \code{ib}.
  \item \code{etrmax_with_without_ratio}: Ratio of \code{etrmax_with_photoinhibition} to \code{etrmax_without_photoinhibition}, and \code{ik_with_photoinhibition} to \code{ik_without_photoinhibition}.
}
}
\description{
This function enhances the Platt (1980) model by adding parameters not originally included in the model, which were introduced by other models. It also renames parameters to a standardized naming convention used across all models.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#platt_modified}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- platt_generate_regression_ETR_II(data)
modified_result <- platt_modified(result)

}
