% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2_samp_var.R
\name{h2_samp_var}
\alias{h2_samp_var}
\title{Calculates expected sampling variance of a given $h^2$ from the A matrix of a pedigree, based on the method of Visscher and Goddard 2015 Genetics}
\usage{
h2_samp_var(Ped, h2 = 0.3, plot = FALSE)
}
\arguments{
\item{Ped}{A pedigree}

\item{h2}{vector of heritabilities for which the sampling variance is calculated.}

\item{plot}{logical. If TRUE, a plot of the sampling variance as a function of h2 is produced (only if length(h2)>1).}
}
\value{
Returns a vector of sampling variances for each given h2.
}
\description{
Calculates expected sampling variance of a given $h^2$ from the A matrix of a pedigree, based on the method of Visscher and Goddard 2015 Genetics
}
\examples{
\donttest{
data(gryphons)
pedigree <- gryphons[, 1:3]

h2_samp_var(pedigree,h2=0.3)
}
}
