% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_sequences.R
\name{reduce_sequences}
\alias{reduce_sequences}
\title{Reduce Peptide Sequences by One Residue}
\usage{
reduce_sequences(peptides, id = NULL)
}
\arguments{
\item{peptides}{A character vector of peptide sequences.}

\item{id}{A character vector of IDs that correspond to the peptides.}
}
\value{
A list of data frames, each containing all possible sequences resulting
        from removing one amino acid from the original sequence.
}
\description{
This function takes a vector of peptide sequences and generates all possible
sequences by removing one amino acid residue at a time. It can also associate each
sequence with an ID, if provided.
}
\examples{
# Generate a mock vector of peptide sequences
peptides <- c("AVILG", "VILGA", "ILGAV", "LGAVI")
# Apply the function to the mock data
reduce_sequences(peptides)
}
