% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphkde.plot.R
\name{sphkde.plot}
\alias{sphkde.plot}
\title{sphkde.plot}
\usage{
sphkde.plot(object, type = "sph", axis = TRUE, shrink = 1.2)
}
\arguments{
\item{object}{Object of the class \code{sphkde}.}

\item{type}{Character string giving the desired type of plot. For circular data, it can be "sph" for a circular representation or "line" for a linear representation. For spherical data the value "sph" is required.}

\item{axis}{Logical; if TRUE, the axis are represented in the spherical representation. If FALSE, axis are not represented. Only for spherical representations.}

\item{shrink}{Numeric parameter that controls the size of the plotted circle in the circular representations. Default is 1.3. Larger values shrink the circle, while smaller values enlarge the circle.}
}
\value{
\code{sphkde.plot} is called for the side effect of drawing the plot.
}
\description{
Function \code{sphkde.plot} provides a graphical representation of the parametrically guided kernel density estimator for spherical and circular data. For circular data, both linear and circular representations are available. For spherical data, an interactive 3D spherical representation is provided.
}
\details{
See Alonso-Pena et al. (2023) for details.
}
\examples{
library(movMF)
n<-200
mu<-matrix(c(0,0,1,0,0,-1),ncol=3,byrow=TRUE)
k<-c(7,2)
probs<-c(0.85,0.15)
datax<-rmovMF(n,k*mu,alpha=probs)
est<-sphkde.pg(datax,guide=TRUE)
sphkde.plot(est,type="sph")
}
\references{
Alonso-Pena, M., Claeskens, G. and Gijbels, I. (2023) Nonparametric estimation of densities on the hypersphere using a parametric guide. Under review.
}
