% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_photon.R
\name{new_photon}
\alias{new_photon}
\title{Initialize a photon instance}
\usage{
new_photon(
  path = NULL,
  url = NULL,
  photon_version = NULL,
  region = NULL,
  opensearch = TRUE,
  mount = TRUE,
  overwrite = FALSE,
  quiet = FALSE,
  country = NULL
)
}
\arguments{
\item{path}{Path to a directory where the photon executable and data
should be stored. Defaults to a directory "photon" in the current
working directory. If \code{NULL}, a remote instance is set up based on
the \code{url} parameter.}

\item{url}{URL of a photon server to connect to. If \code{NULL} and
\code{path} is also \code{NULL}, connects to the public API under
\url{https://photon.komoot.io/}.}

\item{photon_version}{Version of photon to be used. A list of all
releases can be found here: \url{https://github.com/komoot/photon/releases/}.
Ignored if \code{jar} is given. If \code{NULL}, uses the latest known
version.}

\item{region}{Character string that identifies a region or country. An
extract for this region will be downloaded. If \code{"planet"}, downloads
a global extract (see note). Run \code{list_regions()} to get an overview
of available regions. You can specify countries using any code that can
be translated by \code{\link[countrycode]{countrycode}}.}

\item{opensearch}{Deprecated for photon versions >= 1.0.0 and superseded
for photon versions >= 0.7.0. If \code{TRUE},
attempts to download the OpenSearch version of photon. OpenSearch-based
photon supports structured geocoding. If \code{FALSE}, falls back to
ElasticSearch. Since photon 0.7.0, OpenSearch is the default and since
1.0.0, ElasticSearch is not supported anymore.}

\item{mount}{If \code{TRUE}, mounts the object to the session so that
functions like \code{\link{geocode}} automatically detect the new
instance. If \code{FALSE}, initializes the instance but doesn't mount
it to the session. Defaults to \code{TRUE}.}

\item{overwrite}{If \code{TRUE}, overwrites existing jar files and
search indices when initializing a new instance. Defaults to
\code{FALSE}.}

\item{quiet}{If \code{TRUE}, suppresses all informative messages.}

\item{country}{Deprecated since photon 1.0.0. Use \code{region} instead.}
}
\value{
An R6 object of class \code{photon}.
}
\description{
Initialize a photon instance by creating a new photon object. This object
is stored in the R session and can be used to perform geocoding requests.

Instances can either be local or remote. Remote instances require nothing
more than a URL that geocoding requests are sent to. Local instances require
the setup of the photon executable, a search index, and Java. See
\code{\link{photon_local}} for details.
}
\examples{
\dontshow{if (getFromNamespace("is_online", "photon")("graphhopper.com") && getFromNamespace("photon_run_examples", "photon")()) withAutoprint(\{ # examplesIf}
# connect to public API
photon <- new_photon()

# connect to arbitrary server
photon <- new_photon(url = "https://photonserver.org")

if (has_java("11")) {
  # set up a local instance in a temporary directory
  dir <- file.path(tempdir(), "photon")
  photon <- new_photon(dir, region = "Andorra")
  photon$purge(ask = FALSE)
}
\dontshow{\}) # examplesIf}
}
