% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aux.R
\name{get_aux}
\alias{get_aux}
\alias{get_countries}
\alias{get_regions}
\alias{get_cpi}
\alias{get_dictionary}
\alias{get_gdp}
\alias{get_incgrp_coverage}
\alias{get_interpolated_means}
\alias{get_hfce}
\alias{get_pop}
\alias{get_pop_region}
\alias{get_ppp}
\alias{get_region_coverage}
\alias{get_survey_means}
\title{Get auxiliary data}
\usage{
get_aux(
  table = NULL,
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  simplify = TRUE,
  server = NULL,
  assign_tb = FALSE,
  replace = FALSE
)

get_countries(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_regions(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_cpi(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_dictionary(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_gdp(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_incgrp_coverage(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_interpolated_means(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_hfce(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_pop(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_pop_region(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_ppp(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_region_coverage(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)

get_survey_means(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  server = NULL
)
}
\arguments{
\item{table}{Aux table}

\item{version}{character: Data version. See \code{get_versions()}}

\item{ppp_version}{ppp year to be used}

\item{release_version}{date when the data was published in YYYYMMDD format}

\item{api_version}{character: API version}

\item{format}{character: Response format either of c("rds", "json", "csv")}

\item{simplify}{logical: If TRUE (the default) the response is returned as a
\code{tibble}}

\item{server}{character: Server. For WB internal use only}

\item{assign_tb}{assigns table to specified name to the \code{.pip} environment.
If \code{FALSE} no assignment will performed. If \code{TRUE}, the table will be
assigned to  exactly the same name as the one of the desired table. If
character, the table will be assigned to that name.}

\item{replace}{logical: force replacement of aux files in \code{.pip} env. Default
is FALSE.}
}
\value{
If \code{simplify = FALSE}, it returns a list of class "pip_api". If
\code{simplify = TRUE}, it returns a tibble with the requested data. This is the
default. Only for \code{get_aux()}, If \code{assign_tb = TRUE} or character, it
returns TRUE when data was assign properly to .pip env. FALSE, if it was
not assigned.
}
\description{
\code{get_aux()} Get an auxiliary dataset. If no table is specified a
vector with possible inputs will be returned.

\code{get_countries()} Returns a table countries with their full names, ISO
codes, and associated region code
}
\section{Functions}{
\itemize{
\item \code{get_countries()}: Returns a table countries with their full names, ISO
codes, and associated region code

\item \code{get_regions()}: Returns a table regional grouping used for computing
aggregate poverty statistics.

\item \code{get_cpi()}: Returns a table of Consumer Price Index (CPI) values used
for poverty and inequality computations. statistics

\item \code{get_dictionary()}: Returns a data dictionary with a description of all
variables available through the PIP API.

\item \code{get_gdp()}: Returns a table of Growth Domestic Product (GDP) values
used for poverty and inequality statistics.

\item \code{get_incgrp_coverage()}: Returns a table of survey coverage for low and
lower-middle income countries. If this coverage is less than 50\%, World
level aggregate statistics will not be computed.

\item \code{get_interpolated_means()}: Returns a table of key information and statistics for all
years for which poverty and inequality statistics are either available
(household survey exists) or extra- / interpolated. Please see
\code{\link{get_dictionary}} for more information about each variable
available in this table.

\item \code{get_hfce()}: Returns a table of Household Final Consumption
Expenditure (HFCE) values used for poverty and inequality computations.

\item \code{get_pop()}: Returns a table of population values used for poverty and
inequality computations.

\item \code{get_pop_region()}: Returns a table of total population by region-year. These
values are used for the computation of regional aggregate poverty
statistics.

\item \code{get_ppp()}: Returns a table of Purchasing Power Parity (PPP) values
used for poverty and inequality computations.

\item \code{get_region_coverage()}: Return a table of regional survey coverage: Percentage of
available surveys for a specific region-year.

\item \code{get_survey_means()}: Returns a table of all available surveys and associated
key statistics. Please see \code{\link{get_dictionary}} for more
information about each variable available in this table.

}}
\examples{
\dontrun{
# Get list of tables
x <- get_aux()

# Get GDP data
df <- get_aux("gdp")

# Get countries
df <- get_aux("countries")

# Display auxiliary tables
get_aux()

# Display and assign to .pip env the selected auxiliary table
get_aux(assign_tb = TRUE)

# Bind gdp table to "gdp" in .pip env
get_aux("gdp", assign_tb = TRUE)

# Bind gdp table to "new_name" in .pip env
get_aux("gdp", assign_tb = "new_name")

}
\dontrun{
# Short hand to get countries
get_countries()
}
\dontrun{
# Short hand to get regions
get_regions()
}
\dontrun{
# Short hand to get cpi
get_cpi()
}
\dontrun{
# Short hand to get dictionary
get_dictionary()
}
\dontrun{
# Short hand to get gdp
get_gdp()
}
\dontrun{
# Short hand to get incgrp_coverage
get_incgrp_coverage()
}
\dontrun{
# Short hand to get interpolated_means
get_interpolated_means()
}
\dontrun{
# Short hand to get hfce
get_hfce()
}
\dontrun{
# Short hand to get pop
get_pop()
}
\dontrun{
# Short hand to get pop_region
get_pop_region()
}
\dontrun{
# Short hand to get ppp
get_ppp()
}
\dontrun{
# Short hand to get region_coverage
get_region_coverage()
}
\dontrun{
# Short hand to get survey_means
get_survey_means()
}
}
