% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_city.R
\name{match_city}
\alias{match_city}
\title{Match City Names to NUTS Regions}
\usage{
match_city(x, country = "DE", fuzzy = TRUE, threshold = 0.95)
}
\arguments{
\item{x}{Character vector of city names.}

\item{country}{Character string of two-letter country code (e.g. "DE", "FR").}

\item{fuzzy}{Logical, whether to perform fuzzy matching.}

\item{threshold}{Numeric, similarity threshold for fuzzy matching (0-1).}
}
\value{
A data frame with columns: original, city_clean, nuts_3_id, lau_name, match_type, similarity.
}
\description{
Matches a vector of city names to NUTS 3 regions using a cascading logic for any supported country.
}
\examples{
# Match German cities
cities <- c("Berlin", "Munich", "Hamburg")
match_city(cities, country = "DE")

# Match with exact matching only (no fuzzy)
match_city(c("Frankfurt am Main"), country = "DE", fuzzy = FALSE)
}
