% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/const_dmd.R
\name{const_dmd}
\alias{const_dmd}
\title{Calculates the Projected Inventories and Coverages as well as the Constrained Demand and informs a Tag about the part of the Demand already covered by the Opening Inventories}
\usage{
const_dmd(dataset, DFU, Period, Demand, Opening, Supply)
}
\arguments{
\item{dataset}{a dataframe with the demand and supply features for an item per period}

\item{DFU}{name of an item, a SKU, or a node like an item x location}

\item{Period}{a period of time monthly or weekly buckets for example}

\item{Demand}{the quantity of an item planned to be consumed in units for a given period}

\item{Opening}{the opening inventories of an item in units at the beginning of the horizon}

\item{Supply}{the quantity of an item planned to be supplied in units for a given period}
}
\value{
a dataframe with the calculated Projected Inventories and Coverages as well as the Constrained Demand and a Tag informing the part of the Demand already covered by the Opening Inventories
}
\description{
Calculates the Projected Inventories and Coverages as well as the Constrained Demand and informs a Tag about the part of the Demand already covered by the Opening Inventories
}
\examples{
const_dmd(dataset = demo_const_dmd, DFU, Period, Demand, Opening, Supply)

}
