% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.plasso.R
\name{coef.cv.plasso}
\alias{coef.cv.plasso}
\title{Extract coefficients from a \code{\link{cv.plasso}} object}
\usage{
\method{coef}{cv.plasso}(object, ..., s = c("optimal", "all"), se_rule = 0)
}
\arguments{
\item{object}{\code{\link{cv.plasso}} object}

\item{...}{Pass generic \code{\link[stats]{coef}} options}

\item{s}{Determines whether coefficients are extracted for all values of lambda ("all") or only for the optimal lambda ("optimal") according to the specified standard error-rule.}

\item{se_rule}{If equal to 0, predictions from cross-validated MSE minimum (default). Negative values go in the direction of smaller
models, positive values go in the direction of larger models (e.g. \code{se_rule=-1} creates the standard 1SE rule).
This argument is not used for \code{s="all"}.}
}
\value{
List object containing coefficients for both the Lasso and Post-Lasso
models respectively.
\item{lasso}{Sparse \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} with Lasso coefficients}
\item{plasso}{Sparse \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} with Post-Lasso coefficients}
}
\description{
Extract coefficients for both Lasso and Post-Lasso from a \code{\link{cv.plasso}} object.
}
\examples{

# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit cv.plasso to the data
\donttest{p.cv = plasso::cv.plasso(X,y)}
# get estimated coefficients along whole lambda sequence
\donttest{coefs = coef(p.cv, s="all")}
\donttest{head(coefs$plasso)}
# get estimated coefficients for optimal lambda value according to 1-standard-error rule
\donttest{coef(p.cv, s="optimal", se_rule=-1)}

}
