% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alf.R
\name{composite_pair_loss}
\alias{composite_pair_loss}
\title{Composite Pairwise Loss Function}
\usage{
composite_pair_loss(x, fun, trans = identity, rescale = "df", ...)
}
\arguments{
\item{x}{A numeric vector, matrix, or data frame. If not a matrix, it will be
coerced to one after applying the transformation function.}

\item{fun}{A function to compute the loss for each pairwise difference.
The package supports the alignment loss (\code{alf}) and the approximate L0 penalty
(\code{l0a}), but users can provide custom functions as well.}

\item{trans}{A transformation function to apply to \code{x} before computing
pairwise differences. Default is \code{identity} (no transformation).}

\item{rescale}{Either \code{"df"} (default) to rescale the total loss by the degrees
of freedom (number of rows - 1), or a numeric value (likely between 0 and 1)
to multiply the total loss by.}

\item{...}{Additional arguments passed to the loss function \code{fun}.}
}
\value{
A numeric scalar representing the sum of losses across all pairwise
combinations of rows.
}
\description{
Computes the total loss across all pairwise combinations of rows in a matrix.
}
\details{
The function works by:
\enumerate{
\item Applying the transformation function \code{trans} to the input \code{x}
\item Converting the result to a matrix
\item Generating all possible pairwise combinations of row indices
\item Computing the difference between each pair of rows
\item Applying the loss function \code{fun} to each difference
\item Summing all the individual losses
}
}
\examples{
# Example with a simple matrix
x <- matrix(runif(12), nrow = 4)
composite_pair_loss(x, fun = alf)

# Example with log transformation and L2 loss
composite_pair_loss(x, fun = function(x) x^2, trans = log)

}
