% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get_palette}
\alias{get_palette}
\title{Retrieve the color scheme for contour plots.}
\usage{
get_palette(color, nCol = 50, col = NULL)
}
\arguments{
\item{color}{A string, or vector of strings, indicating a color palette. 
Includes: 'topo', 'heat', 'bwr', 'cm', 'terrain', 'bpy', 'gray', 'bw',
or user defined colors.}

\item{nCol}{The number of colors to use in color schemes.}

\item{col}{Color of contour lines for the contour plots. 
If NULL (default), a color is determined, depending on the color palette.}
}
\value{
Color palette.
}
\description{
Retrieve the color scheme for contour plots.
}
\examples{
pal <- get_palette('terrain', nCol=10)
names(pal)
image(matrix(1:10, ncol=10), col=pal$color, axes=FALSE)
# user defined color palette:
pal <- get_palette(c('green', 'orange', 'red'))
image(matrix(1:10, ncol=10), col=pal$color, axes=FALSE)

}
\seealso{
\code{\link{plotsurface}}, \code{\link{gradientLegend}}

Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{keepFigRatio}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\concept{Utility functions}
