% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_security.R
\name{api_security_cors}
\alias{api_security_cors}
\title{Set up CORS for a path in your plumber2 API}
\usage{
api_security_cors(
  api,
  path = "/*",
  origin = "*",
  methods = c("get", "head", "put", "patch", "post", "delete"),
  allowed_headers = NULL,
  exposed_headers = NULL,
  allow_credentials = FALSE,
  max_age = NULL
)
}
\arguments{
\item{api}{A plumber2 api object to add the plugin to}

\item{path}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{origin}{The origin allowed for the path. Can be one of:
\itemize{
\item A boolean. If \code{TRUE} then all origins are permitted and the preflight
response will have the \code{Access-Control-Allow-Origin} header reflect
the origin of the request. If \code{FALSE} then all origins are denied
\item The string \code{"*"} which will allow all origins and set
\code{Access-Control-Allow-Origin} to \code{*}. This is different than setting it
to \code{TRUE} because \code{*} instructs browsers that any origin is allowed and
it may use this information when searching the cache
\item A character vector giving allowed origins. If the request origin
matches any of these then the \code{Access-Control-Allow-Origin} header in
the response will reflect the origin of the request
\item A function taking the request and returning \code{TRUE} if the origin is
permitted and \code{FALSE} if it is not. If permitted the
\code{Access-Control-Allow-Origin} header will reflect the request origin
}}

\item{methods}{The HTTP methods allowed for the \code{path}}

\item{allowed_headers}{A character vector of request headers allowed when
making the request. If the request contains headers not permitted, then
the response will be blocked by the browser. \code{NULL} will allow any header
by reflecting the \code{Access-Control-Request-Headers} header value from the
request into the \code{Access-Control-Allow-Headers} header in the response.}

\item{exposed_headers}{A character vector of response headers that should
be made available to the client upon a succesful request}

\item{allow_credentials}{A boolean indicating whether credentials are
allowed in the request. Credentials are cookies or HTTP authentication
headers, which are normally stripped from \code{fetch()} requests by the
browser. If this is \code{TRUE} then \code{origin} cannot be \code{*} according to the
spec}

\item{max_age}{The duration browsers are allowed to keep the preflight
response in the cache}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This function adds Cross-Origin Resource Sharing (CORS) to a path in your
API. The function can be called multiple times to set up CORS for multiple
paths, potentially with different settings for each path. CORS is a complex
specification and more can be read about it at the \link[firesafety:CORS]{CORS}
plugin documentation.
}
\section{Using annotation}{
To add CORS to a path you can add \verb{@cors <origin>} to a
handler annotation. \verb{<origin>} must be one or more URLs or \code{*}, separated by
comma (meaning it is not possible to provide a function using the annotation).
This will add CORS to all endpoints described in the block. The annotation
doesn't allow setting \code{allowed_headers}, \code{exposed_headers},
\code{allow_credentials} or \code{max_age} and the default values will be used.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A handler for /user/<username>
#*
#* @param username:string The name of the user to provide information on
#*
#* @get /user/<username>
#*
#* @response 200:\{name:string, age:integer, hobbies:[string]\} Important
#* information about the user such as their name, age, and hobbies
#*
#* @cors https://example.com, https://another-site.com
#*
function(username) \{
  find_user_in_db(username)
\}
}\if{html}{\out{</div>}}
}

\examples{
# Set up cors for your asset/ path for the https://examples.com origin

api() |>
  api_security_cors(
    path = "asset/*",
    origin = "https://examples.com"
  )

}
\seealso{
Other security features: 
\code{\link{api_security_headers}()},
\code{\link{api_security_resource_isolation}()}
}
\concept{security features}
