% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_generators.R
\name{nn_generator_nm}
\alias{nn_generator_nm}
\title{Internal: Generate NN code for NONMEM}
\usage{
nn_generator_nm(
  number,
  state,
  n_hidden = 5,
  act = "ReLU",
  time_nn = FALSE,
  beta = 20
)
}
\arguments{
\item{number}{(string) Name of the NN}

\item{state}{(string) State to be used as input of the NN}

\item{n_hidden}{(numeric) Number of units in the hidden layer; currently not implemented for the NN function}

\item{act}{(string) Activation function to be used in the hidden layer of the NN (currently ReLU and Softplus implemented), default is ReLU}

\item{time_nn}{(boolean) If NN should be set up specifically as a time-dependent NN with strictly negative weights
from input to hidden layer through w'=-w^2}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}
}
\value{
Explicit NN code in NONMEM as list of lines in NONMEM model file
}
\description{
Generate the explicit code for a NN in NONMEM
}
\details{
Structure of one unit in the hidden layer: \cr
h1 = 0 \cr
h1_thres = W1 * state + b1 \cr
IF (h1_thres.GT.h1) h1 = h1_thres \cr
h2 = 0 \cr
... \cr
NN = h1 + h2 + ... \cr
}
\author{
Dominic Bräm
}
\keyword{internal}
