% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_mlx.R
\name{pre_fixef_extractor_mlx}
\alias{pre_fixef_extractor_mlx}
\title{Monolix estimations extractor}
\usage{
pre_fixef_extractor_mlx(model_name)
}
\arguments{
\item{model_name}{(string) Name of the Monolix run. Must include \dQuote{.mlxtran}}
}
\value{
Named vector of Monolix parameter estimations
}
\description{
When the Monolix model has been run, e.g., with only population estimation, this function allows to extract the
estimated parameters from the Monolix run folder. This function is meant, e.g., to get initial values for a
Monolix run with inter-individual variability and to be then used as \emph{pre_fixef} argument in the
\emph{nn_converter_mlx} function
}
\examples{
mlx_path <- system.file("extdata","mlx_example1_ind.mlxtran",package="pmxNODE")
est_parms <- pre_fixef_extractor_mlx(mlx_path)
}
\author{
Dominic Bräm
}
