# Regression tests for rodent, ant, and plant output

portal_data_path <- tempdir()

test_that("data generated by default setting is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, level = "Site",
                    type = "Rodents", plots = "all", unknowns = FALSE,
                    min_plots = 24, shape = "crosstab", time = "period") %>%
          dplyr::filter(period < 434) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by level = treatment, plots = longterm is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, level = "treatment", plots = "longterm") %>%
          dplyr::filter(period < 434) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by level = plot, time = newmoon, type = granivore, shape = flat is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, level = 'plot', type = "granivores",
                    shape = "flat", time = "newmoon", na_drop = FALSE) %>%
          dplyr::filter(newmoonnumber < 465) %>%
          dplyr::group_by(species,treatment) %>%
          dplyr::summarise(abundance = sum(abundance, na.rm=TRUE))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by na_drop = FALSE, zero_drop = FALSE is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, time = "date", na_drop = FALSE,
                    zero_drop = FALSE, min_plots = 1) %>%
          dplyr::filter(censusdate < as.Date("2015-01-01"))

  expect_equal(dim(data), c(464, 22))
  data <- data %>%
          dplyr::select(-censusdate) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))

  attributes(data) <- attributes(data)[sort(names(attributes(data)))]

  expect_snapshot_value(data, style = "serialize")

  data2 <- abundance(portal_data_path, time = "newmoon", min_plots = 1,
                    include_unsampled = TRUE) %>%
           dplyr::filter(newmoonnumber < 465)
  expect_equal(dim(data2), c(464, 22))
  data2 <- data2 %>%
           dplyr::select(-newmoonnumber) %>%
           dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data2) <- attributes(data2)[sort(names(attributes(data2)))]
  expect_equal(data2, data)
})

test_that("data generated by unknowns = T, min_plots = 1 is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, min_plots = 1, unknowns = TRUE) %>%
          dplyr::filter(period < 434) %>%
          dplyr::select(period, BA, DM, DO, DS, "NA", OL, OT, other, PB,
                  PE, PF, PH, PI, PL, PM, PP, RF, RM, RO, SF, SH, SO) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by plots = c(4, 8, 10, 12) is same", {
  skip_on_cran()
  data <- summarize_rodent_data(path = portal_data_path, plots = c(4, 8, 10, 12),
                                na_drop = TRUE, zero_drop = FALSE) %>%
          dplyr::filter(period < 450) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("biomass data generated by level = plot is same", {
  skip_on_cran()
  data <- biomass(portal_data_path, type = "rodents", level = "plot", na_drop = FALSE) %>%
          dplyr::filter(period < 434) %>%
          dplyr::mutate_if(is.numeric, round, 1) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("biomass data generated by min_plots = 1 is same", {
  skip_on_cran()
  data <- biomass(portal_data_path, type = "rodents", min_plots = 1) %>%
          dplyr::filter(period < 434) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 3)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("rates data generated by plots crosstab is same", {
  skip_on_cran()
  data <- rates(portal_data_path, type = "rodents", level = "plot") %>%
          dplyr::filter(period < 434) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 3)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by default setting is same (plants)", {
  skip_on_cran()
  data <- plant_abundance(portal_data_path, level = 'Site',
                          type = "All", plots = "all", unknowns = FALSE,
                          correct_sp = TRUE, shape = "flat", na_drop = TRUE,
                          zero_drop = TRUE, min_quads = 1, effort = TRUE) %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$abundance), 1431837)
})

test_that("data generated by type = Shrubs, unknowns = T, correct_sp = F is same (plants)", {
  skip_on_cran()
  data <- plant_abundance(portal_data_path, level = 'Site',
                          type = "Shrubs", plots = "all", unknowns = TRUE,
                          correct_sp = FALSE, shape = "flat", na_drop = TRUE,
                          zero_drop = TRUE, min_quads = 1, effort = TRUE) %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$abundance), 12961)
})

test_that("data generated by level = Plot, type = Annuals, plots = longterm is same (plants)", {
  skip_on_cran()
  data <- plant_abundance(portal_data_path, level = 'Plot',
                          type = "Annuals", plots = "longterm",
                          unknowns = TRUE, correct_sp = TRUE, shape = "flat",
                          na_drop = TRUE, zero_drop = TRUE, min_quads = 1, effort = TRUE) %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$abundance), 719660)
})

test_that("data generated by level = quadrat is same (plants)", {
  skip_on_cran()
  data <- plant_abundance(portal_data_path, level = 'quadrat') %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$abundance), 1431837)
})

test_that("data generated by level = quadrat, shape = crosstab, output = cover is same (plants)", {
  skip_on_cran()
  data <- summarize_plant_data(portal_data_path, level = 'quadrat', shape = "crosstab",
                               output = "cover") %>%
          dplyr::filter(year == 2015) %>%
          dplyr::select_if(is.numeric) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 1)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by shape = crosstab is same (plants)", {
  skip_on_cran()
  selected_plants <- sort(c("carl line", "tria port", "amar palm", "atri acan", "atri cane", "atri eleg", "atri wrig", "chen frem", "chen sp", "bray dens", "sals kali", "euro lana", "tide lanu", "tide sp", "sper echi", "funa hart", "dich pulc", "yucc elat", "ambr arte", "ambr conf", "ambr sals", "bahi absi", "bahi bite", "bail mult", "bric eupa", "caly wrig", "chae stev", "chae eric", "cirs neom", "erig conc", "erig dive", "erig sp", "flou cern", "guti saro", "hapl sp", "hapl spin", "heli annu", "hete suba", "hapl tenu", "laen coul", "hapl grac", "mach tanr", "mala fend", "mala sp", "part inca", "pect papp", "pere nana", "pseu cane", "rafi neom", "sanv aber", "step exig", "dyss pent", "micr lene", "micr sp", "verb ence", "xant spin", "zinn pumi", "zinn gran", "zinn sp", "amsi inte", "amsi sp", "amsi tess", "cryp cras", "cryp micr", "cryp sp", "cryp sp2", "lapp redo", "nama hisp", "pect recu", "pect sp", "phac ariz", "plag ariz", "chor tene", "desc obtu", "desc pinn", "desc sp", "dith wisl", "lepi lasi", "lepi sp", "lesq gord", "sisy irio", "unkn must", "cyli fulg", "cyli sp", "opun basi", "opun poly", "opun sp", "comm erec", "cusc mitr", "cusc sp", "cusc tube", "ipom cost", "apod undu", "ephe trif", "crot cory", "euph exst", "euph fend", "euph micr", "euph serp", "euph serr", "euph sp", "erod cicu", "erod texa", "acac cons", "acac greg", "astr allo", "astr nutt", "astr sp", "cass lept", "crot pumi", "dale brac", "dale nana", "dale pogo", "dale sp", "hoff dens", "lupi brev",  "lupi conc", "lupi sp", "lupi sp2", "mimo acul", "pros glan", "pros sp", "pros velu", "cass bauh", "abut parv", "sida phys", "sida proc", "sida neom", "sida sp", "sida spin", "spha angu", "spha coul", "spha hast", "spha inca", "spha laxa", "spha sp", "prob parv", "moll cerv", "moll sp", "moll vert", "tali angu", "tali aura", "tali sp", "alli inca", "alli sp", "ammo chen", "boer cocc", "boer coul", "boer inte", "boer sp", "boer torr", "oeno prim", "oeno sp", "esch mexi", "lina texa", "plan purs", "aris adsc", "aris long", "aris sp", "aris hamu", "both barb", "bout aris", "bout sp", "pani ariz", "brom rube", "bout dact", "chlo virg", "bout barb", "bout erio", "tric cali", "sita hyst", "enne desv", "erag cili", "erag inte", "erag lehm", "erag arid", "erag sp", "erio lemm", "trid pulc", "hila muti", "lycu phle", "muhl port", "muhl sp", "pani hirt", "pani mili", "pani sp", "schi barb", "seta leuc", "seta macr", "spor cont", "trag bert", "annu gras", "annu gras1", "annu gras2", "unkn gras", "unkn gras2", "pere gras", "vulp octo", "eria diff", "gili mexi", "gili sinu", "lina bige", "lina sp", "poly twee", "erio aber", "erio poly", "rume alti", "rume angu", "rume hyme", "port parv", "port sp", "port suff", "andr occi", "delp sp", "lyci ande", "lyci torr", "sola elea", "sola rost", "papp vagi", "annu forb", "annu forb2", "annu forb3", "annu forb4", "annu forb5", "unkn forb", "unkn forb2", "pere forb", "unkn", "unkn shrb", "tetr coul", "kall cali", "kall gran", "kall hirs", "kall sp", "larr trid"))
  data <- plant_abundance(portal_data_path, shape = "crosstab") %>%
          dplyr::filter(year < 2015) %>%
          dplyr::select(tidyselect::any_of(c("year", "season", "quads", selected_plants))) %>%
          dplyr::select_if(is.numeric) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 1)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]
  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by default setting is same (shrub_cover)", {
  skip_on_cran()
  data <- shrub_cover(path = portal_data_path, type = "Shrubs",
                      plots = "all", unknowns = FALSE,
                      correct_sp = TRUE) %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$cover,na.rm=TRUE), 22.917)
  expect_equal(sum(data$height,na.rm=TRUE), 0)
})

test_that("data generated by default setting is same (ant colony_presence_absence)", {
  skip_on_cran()
  data <- colony_presence_absence(portal_data_path, level = "site") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),257)
})

test_that("data generated by default setting is same (ant bait_presence_absence)", {
  skip_on_cran()
  data <- bait_presence_absence(portal_data_path, level = "Site") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),246)
})

test_that("data generated by level = 'stake' is same (ant colony_presence_absence)", {
  skip_on_cran()
  data <- colony_presence_absence(portal_data_path, level = "stake") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),30122)
})

test_that("data generated by level = 'stake' is same (ant bait_presence_absence)", {
  skip_on_cran()
  data <- bait_presence_absence(portal_data_path, level = "stake") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),12412)
})

test_that("data generated by level = 'plot' is same (ant colony_presence_absence)", {
  skip_on_cran()
  data <- colony_presence_absence(portal_data_path, level = "plot") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),4172)
})

test_that("data generated by level = 'plot' is same (ant bait_presence_absence)", {
  skip_on_cran()
  data <- bait_presence_absence(portal_data_path, level = "plot") %>%
          dplyr::filter(year < 2015)
  expect_equal(sum(data$presence,na.rm=TRUE),2489)
})

test_that("data generated by default setting is same (weather)", {
  skip_on_cran()
  data <- weather(path = portal_data_path) %>%
          dplyr::filter(year < 2015) %>%
          dplyr::select_if(is.numeric) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 1)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]

  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by fill = TRUE is same (weather)", {
  skip_on_cran()
  data <- weather(fill = TRUE, path = portal_data_path) %>%
          dplyr::filter(year < 2015) %>%
          dplyr::select_if(is.numeric) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate_if(is.numeric, round, 1)
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]

  expect_snapshot_value(data, style = "serialize")
})

test_that("data generated by default setting is same (NDVI)", {
  skip_on_cran()
  data <- ndvi(path = portal_data_path) %>%
    dplyr::filter(date < as.Date("2015-01-01")) %>%
    dplyr::mutate(dplyr::across(where(is.double), \(x) round(x,  4)))

  expect_equal(sum(data$ndvi,na.rm = TRUE),53.4313)
})

test_that("data generated by fill = TRUE is same (NDVI)", {
  skip_on_cran()
  data <- ndvi(path = portal_data_path, fill = TRUE, corrected = FALSE) %>%
    dplyr::filter(date < as.Date("2015-01-01")) %>%
    dplyr::mutate(dplyr::across(where(is.double), \(x) round(x,  4)))

  expect_equal(sum(data$ndvi),58.0622)
})

test_that("data generated by forecast = TRUE is same (NDVI)", {
    skip_on_cran()
    data <- ndvi(path = portal_data_path, level = "monthly", corrected = FALSE, forecast = TRUE) %>%
        dplyr::filter(date < as.Date("2015-01-01")) %>%
        dplyr::mutate(dplyr::across(where(is.double), \(x) round(x,  4)))

    expect_equal(sum(data$ndvi),53.593)

    data <- ndvi(path = portal_data_path, level = "newmoon", corrected = FALSE, forecast = TRUE) %>%
        dplyr::filter(newmoonnumber < 250) %>%
        dplyr::mutate(dplyr::across(where(is.double), \(x) round(x,  4)))

    expect_equal(sum(data$ndvi),22.0837)
})

test_that("get_future_newmoons returns identical table using sample input", {
  skip_on_cran()
  moons <- data.frame(newmoonnumber = c(1, 2),
                      newmoondate = c("1977-07-16", "1977-08-14"),
                      period = c(1, 2),
                      censusdate = c("1977-07-16", "1977-08-19"))

  newmoons <- get_future_newmoons(moons, nfuture_newmoons = 10)
  attributes(newmoons) <- attributes(newmoons)[sort(names(attributes(newmoons)))]

  expect_snapshot_value(newmoons, style = "serialize")
})

test_that("data generated by default setting is same (phenocam)", {
  skip_on_cran()
  data <- phenocam(path = portal_data_path) %>%
          dplyr::filter(year < 2019) %>%
          dplyr::select_if(is.numeric) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE))) %>%
          dplyr::mutate(dplyr::across(where(is.double), \(x) round(x,  4)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]

  expect_snapshot_value(data, style = "serialize")
})

test_that("seasonal summaries generated by default setting is same", {
  skip_on_cran()
  data <- abundance(portal_data_path, level = 'Site',
                    type = "Rodents", plots = "all", unknowns = FALSE,
                    min_plots = 24, shape = "crosstab", time = "period") %>%
          dplyr::filter(period < 434) %>%
          add_seasons(date_column = "period", path = portal_data_path) %>%
          dplyr::summarise(dplyr::across(where(is.numeric), \(x) sum(x, na.rm = TRUE)))
  attributes(data) <- attributes(data)[sort(names(attributes(data)))]

  expect_snapshot_value(data, style = "serialize")
})
