% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-precision.R
\name{add_decision_overlay}
\alias{add_decision_overlay}
\title{Add sample-size decision overlay to an assurance contour}
\usage{
add_decision_overlay(p, decisions, x_effect = NULL, colour = "red")
}
\arguments{
\item{p}{A ggplot object, typically from \code{plot_power_contour()}.}

\item{decisions}{A data.frame or tibble returned by
\code{decide_sample_size()}, containing at least one effect column
and \code{n_recommended}.}

\item{x_effect}{Name of the effect column to use on the x-axis.
If \code{NULL}, the first column that is not \code{n_recommended}
or \code{rationale} is used.}

\item{colour}{Colour for the overlay line (default "red").}
}
\value{
A ggplot object.
}
\description{
Overlays the output of \code{decide_sample_size()} as a step-line
on a contour plot (e.g. from \code{plot_power_contour()}).
}
\details{
If the decisions contain multiple effect-grid columns, the
overlay is aggregated over all effect columns except \code{x_effect}
by taking the worst-case (maximum) recommended n at each value
of \code{x_effect}.
}
