% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_species}
\alias{simulate_species}
\alias{simulate_species.Raster}
\alias{simulate_species.SpatRaster}
\title{Simulate species habitat suitability data}
\usage{
simulate_species(x, n, scale)

\method{simulate_species}{Raster}(x, n = 1, scale = 0.5)

\method{simulate_species}{SpatRaster}(x, n = 1, scale = 0.5)
}
\arguments{
\item{x}{\code{\link[terra:rast]{terra::rast()}} object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{scale}{\code{numeric} parameter to control level of spatial
auto-correlation in the simulated data.
Defaults to 0.5.}
}
\value{
A \code{\link[terra:rast]{terra::rast()}} object with values between zero and one.
}
\description{
Generates simulated species data using Gaussian random fields.
}
\examples{
\dontrun{
# create raster
r <- terra::rast(
  ncols = 10, nrows = 10, xmin = 0, xmax = 1, ymin = 0, ymax = 1, vals = 1
)

# simulate data for 4 species
spp <- simulate_species(r, 4)

# plot simulated species
plot(spp, main = "simulated species distributions", axes = FALSE)
}

}
\seealso{
Other functions for simulating data:
\code{\link{simulate_cost}()},
\code{\link{simulate_data}()}
}
\concept{simulations}
