% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table1.R
\name{px_next_update}
\alias{px_next_update}
\alias{px_next_update.px}
\title{NEXT-UPDATE}
\usage{
px_next_update(x, value, validate)

\method{px_next_update}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string. If missing, the current NEXT-UPDATE is returned. If NULL, NEXT-UPDATE is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or a character string.
}
\description{
Inspect or change NEXT-UPDATE.
}
\examples{
# Set NEXT-UPDATE
x1 <-
   px(population_gl) |>
   px_next_update('20240621 15:55')

# Print NEXT-UPDATE
px_next_update(x1)

# Remove NEXT-UPDATE
x2 <- px_next_update(x1, NULL)
px_next_update(x2)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A49\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C144\%2C0\%5D}{Statistics Sweden's documentation}
}
