% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{dataChk}
\alias{dataChk}
\title{dataChk}
\usage{
dataChk(
  d,
  checks,
  id = character(0),
  html = FALSE,
  omit0 = FALSE,
  byid = FALSE,
  nrows = 500
)
}
\arguments{
\item{d}{a data table}

\item{checks}{a vector of expressions that if satisfied causes records to be listed}

\item{id}{option vector of variable names to serve as IDs}

\item{html}{set to \code{TRUE} to create HTML output and put each check in a separate tab, also creating summary tabs}

\item{omit0}{set to \code{TRUE} to ignore checks finding no observations}

\item{byid}{if \code{id} is given set \code{byid=TRUE} to also list a data frame with all flagged conditions, sorted by \code{id}}

\item{nrows}{maximum number of rows to allow to be printed}
}
\value{
an invisible data frame containing variables \code{check} (the expression checked) and \code{n} (the number of records satisfying the expression)
}
\description{
Run a Series of Data Checks and Report
}
\details{
Function to run various data checks on a data table.

Checks are run separately for each part of the \code{expression} vector \code{checks}.  For each single expression, the variables listed in the output are all the variables mentioned in the expression plus optional variables whose names are in the character vector \code{id}. \verb{\%between\% c(a,b)} in expressions is printed as \verb{[a,b]}.  The output format is plain text unless \code{html=TRUE} which also puts each table in a separate Quarto tab.  See \href{https://www.fharrell.com/post/rflow/}{here} for examples.
}
\examples{
\dontrun{
dataChk(mydata)
}
}
\author{
Frank Harrell
}
