% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull.corpus}
\alias{pull.corpus}
\alias{pull.tokens}
\alias{pull.dfm}
\title{Pull out a single document variable}
\usage{
\method{pull}{corpus}(.data, var = -1, name = NULL, ...)

\method{pull}{tokens}(.data, var = -1, name = NULL, ...)

\method{pull}{dfm}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{a \pkg{quanteda} object with document variables}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names and column locations).}

\item{name}{An optional parameter that specifies the column to be used
as names for a named vector. Specified in a similar manner as \code{var}.}

\item{...}{For use by methods.}
}
\value{
A vector containing the values of the specified document variable.
}
\description{
Works like \code{$} for \pkg{quanteda} objects with document variables, or like
\code{docvars(x, "varname")}.
}
\examples{
tail(data_corpus_inaugural) \%>\% pull(President)
tail(data_corpus_inaugural) \%>\% pull(-1)
tail(data_corpus_inaugural) \%>\% pull(1)

toks <- data_corpus_inaugural \%>\%
  tail() \%>\%
  tokens()
pull(toks, President)

dfmat <- data_corpus_inaugural \%>\%
  tail() \%>\%
  tokens() \%>\%
  dfm()
pull(dfmat, President)

}
