% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{risk_register_pharma}
\alias{risk_register_pharma}
\title{Pharma Risk Register}
\format{
A tibble with 18 rows and 9 columns:
\describe{
\item{risk_id}{Character. Unique risk identifier (RISK-001 to RISK-018).}
\item{description}{Character. Risk description.}
\item{category}{Character. Risk category.}
\item{probability}{Integer. Probability of occurrence (1-5).}
\item{impact}{Integer. Impact severity (1-5).}
\item{detectability}{Integer. Detectability rating (1-5).}
\item{owner}{Character. Risk owner name.}
\item{mitigation}{Character. Mitigation action (or NA).}
\item{status}{Character. Status: open, mitigated, closed, accepted.}
}
}
\source{
Synthetic risk register based on ICH (International Council
for Harmonisation) Q9 quality risk management principles.
}
\usage{
risk_register_pharma
}
\description{
A Failure Mode and Effects Analysis (FMEA)-based risk register with
18 risks covering data quality, traceability, documentation,
programming, and compliance categories. Includes probability, impact,
and detectability scores on a 1-5 scale. Structured according to
ICH (International Council for Harmonisation) Q9 quality risk
management principles.
}
\examples{
data(risk_register_pharma)
table(risk_register_pharma$category)
}
\keyword{datasets}
