% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lwt.R
\name{lwt}
\alias{lwt}
\title{Lifting Wavelet Transform (Forward)}
\usage{
lwt(signal, scheme, levels = 1, extension = "symmetric")
}
\arguments{
\item{signal}{Numeric vector containing the input signal.}

\item{scheme}{A \code{lifting_scheme} object.}

\item{levels}{Integer. Number of decomposition levels.}

\item{extension}{Boundary extension mode: "symmetric" (default),
"periodic", or "zero".}
}
\value{
An object of class 'lwt'. It is a list containing
'coeffs' (list of details d1..dn and approximation an) and
'scheme' (the scheme object used).
}
\description{
Performs the Forward Wavelet Transform using the Lifting Scheme.
Optimized with 'C++' backend.
}
\examples{
data = c(1, 2, 3, 4, 5, 6, 7, 8)
sch = lifting_scheme("haar")
res = lwt(data, sch, levels = 2)
print(res)
}
