% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde_spacetime.R
\name{rspde.spacetime}
\alias{rspde.spacetime}
\title{Space-Time Random Fields via SPDE Approximation}
\usage{
rspde.spacetime(
  mesh_space = NULL,
  mesh_time = NULL,
  space_loc = NULL,
  time_loc = NULL,
  drift = TRUE,
  alpha,
  beta,
  prior.kappa = NULL,
  prior.sigma = NULL,
  prior.rho = NULL,
  prior.gamma = NULL,
  prior.precision = NULL,
  graph_dirichlet = TRUE,
  bounded_rho = TRUE,
  bound_rho = NULL,
  shared_lib = "detect",
  debug = FALSE,
  ...
)
}
\arguments{
\item{mesh_space}{Spatial mesh for the FEM approximation, or a \code{metric_graph}
object for handling models on metric graphs.}

\item{mesh_time}{Temporal mesh for the FEM approximation.}

\item{space_loc}{A vector of spatial locations for mesh nodes in 1D spatial models.
This should be provided when \code{mesh_space} is not specified.}

\item{time_loc}{A vector of temporal locations for mesh nodes. This should be
provided when \code{mesh_time} is not specified.}

\item{drift}{Logical value indicating whether the drift term should be included.
If \code{FALSE}, the drift coefficient \eqn{\rho} is set to zero.}

\item{alpha}{Integer smoothness parameter \eqn{\alpha}.}

\item{beta}{Integer smoothness parameter \eqn{\beta}.}

\item{prior.kappa}{A list specifying the prior for the range parameter \eqn{\kappa}.
This list may contain two elements: \code{mean} and/or \code{precision}, both of which must
be numeric scalars (numeric vectors of length 1). The precision refers to the prior
on \eqn{\log(\kappa)}. If \code{NULL}, default values will be used. The \code{mean} value is also used as starting value for kappa.}

\item{prior.sigma}{A list specifying the prior for the variance parameter \eqn{\sigma}.
This list may contain two elements: \code{mean} and/or \code{precision}, both of which must
be numeric scalars. The precision refers to the prior on \eqn{\log(\sigma)}. If \code{NULL},
default values will be used. The \code{mean} value is also used as starting value for sigma.}

\item{prior.rho}{A list specifying the prior for the drift coefficient \eqn{\rho}.
This list may contain two elements: \code{mean} and/or \code{precision}, both of which must
be numeric scalars if dimension is one, and numeric vectors of length 2 if dimension is 2.
The precision applies directly to \eqn{\rho} without log transformation.
If \code{NULL}, default values will be used. Will not be used if \code{drift = FALSE}. The \code{mean} value is also used as starting value for rho.}

\item{prior.gamma}{A list specifying the prior for the weight \eqn{\gamma} in the SPDE
operator. This list may contain two elements: \code{mean} and/or \code{precision}, both of which
must be numeric scalars. The precision refers to the prior on \eqn{\log(\gamma)}. If \code{NULL},
default values will be used. The \code{mean} value is also used as starting value for gamma.}

\item{prior.precision}{A precision matrix for \eqn{\log(\kappa), \log(\sigma), \log(\gamma), \rho}. This matrix replaces the precision
element from \code{prior.kappa}, \code{prior.sigma}, \code{prior.gamma}, and \code{prior.rho} respectively. For dimension 1 \code{prior.precision} must be a 4x4 matrix. For dimension 2, \eqn{\rho} is a vector of length 2, so in this case \code{prior.precision} must be a 5x5 matrix. If \code{NULL}, a diagonal precision matrix with default values will be used.}

\item{graph_dirichlet}{For models on metric graphs, use Dirichlet vertex conditions at vertices of degree 1?}

\item{bounded_rho}{Logical. Should \code{rho} be bounded to ensure the existence, uniqueness, and well-posedness of the solution? Defaults to \code{TRUE}.
Note that this bounding is not a strict condition; there may exist values of rho beyond the upper bound that still satisfy these properties.
When \code{bounded_rho = TRUE}, the \code{rspde_lme} models enforce bounded \code{rho} for consistency.
If the estimated value of \code{rho} approaches the upper bound too closely, we recommend refitting the model with \code{bounded_rho = FALSE}. However, this should be done with caution, as it may lead to instability in some cases, though it can also result in a better model fit.
The actual bound used for \code{rho} can be accessed from the \code{bound_rho} element of the returned object.}

\item{bound_rho}{A positive number specifying the bound for \code{rho}. If \code{NULL}, the default bound will be used.}

\item{shared_lib}{String specifying which shared library to use for the Cgeneric
implementation. Options are "detect", "INLA", or "rSPDE". You may also specify the
direct path to a .so (or .dll) file.}

\item{debug}{Logical value indicating whether to enable INLA debug mode.}

\item{...}{Additional arguments passed internally for configuration purposes.}
}
\value{
An object of class \code{inla_rspde_spacetime} representing the FEM approximation of
the space-time Gaussian random field.
}
\description{
\code{rspde.spacetime} computes a Finite Element Method (FEM) approximation of a
Gaussian random field defined as the solution to the stochastic partial
differential equation (SPDE):
\deqn{d u + \gamma(\kappa^2 + \kappa^{d/2}\rho\cdot\nabla - \Delta)^\alpha u = \sigma dW_C}
where \eqn{C} is a Whittle-Matérn covariance operator with smoothness parameter
\eqn{\beta} and range parameter \eqn{\kappa}. This function is designed to handle
space-time random fields using either 1D spatial models or higher-dimensional
FEM-based approaches.
}
