% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_Spec_Act.R
\name{RN_Spec_Act}
\alias{RN_Spec_Act}
\title{Specific Activity}
\usage{
RN_Spec_Act(RN_select, numeric = "n")
}
\arguments{
\item{RN_select}{identify the radionuclide of interest in the format "Es-254m". For multiple specific activities, combine the radionuclides of interest in the form, c("At-219", "Es-251").}

\item{numeric}{default is "n" and a data frame is returned showing the radionuclide, its relative specific activity, and the units. If "y", or any other option is selected for the numeric parameter, specific activity results are delivered as numeric.}
}
\value{
specific activity in Bq / g
}
\description{
Provides specific activity of a radionuclide in Bq/g.
}
\examples{
RN_Spec_Act("Ac-230")
RN_Spec_Act(c("At-219", "Es-251"))
RN_Spec_Act("Pd-96", numeric = "y")
RN_Spec_Act(c("Cs-137", "Ba-137m"), numeric = "y")
}
\seealso{
Other radionuclides: 
\code{\link{RN_bin_screen_phot}()},
\code{\link{RN_index_screen}()},
\code{\link{RN_info}()},
\code{\link{RN_plot_df}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_plot_spectrum}()},
\code{\link{RN_save_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
