% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rap_16day.R
\name{get_rap_production16day_table}
\alias{get_rap_production16day_table}
\title{Query RAP 16-day Production Data}
\usage{
get_rap_production16day_table(
  aoi,
  year = NULL,
  mask = TRUE,
  nodata_flag = NA_real_
)
}
\arguments{
\item{aoi}{Area of Interest. A \code{SpatVector} object, or any spatial object
that can be converted with \code{terra::vect()}. The AOI coordinates will be
transformed to WGS84 longitude latitude (\code{"EPSG:4326"}). The AOI can be
specified using point, line and polygon geometries. Each unique feature
will be passed separately to the API. The result \code{feature} column contains
the row index of the input feature from \code{aoi}.}

\item{year}{integer. Optional. Numeric year or vector of years (1986 to last
full year). Default: \code{NULL} returns all available years.}

\item{mask}{logical. Exclude cropland, development, and water? Default:
\code{TRUE}.}

\item{nodata_flag}{numeric. Value to use for missing data. The API encodes
"NODATA" as \code{-99}. Default: \code{NA_real_} replaces \code{-99} with \code{NA}.}
}
\value{
A data.frame with 16-day production data including the following
columns: \code{"date"} (production estimate date), \code{"year"} (production estimate
year), \code{"doy"} (production estimate Julian day of year), \code{"AFG"} (Annual
Forb and Grass production), \code{"PFG"} (Perennial Forb and Grass production),
\code{"HER"} (Herbaceous production), \code{"feature"} (feature ID, row number from
\code{aoi})
}
\description{
Retrieves remotely sensed production estimates from the Rangeland Analysis
Platform (RAP) using the \code{production16dayV3} API endpoint. This function
supports querying one or more spatial features (points, lines, or polygons)
provided as a \code{terra} \code{SpatVector} in WGS84 longitude latitude
(\code{"EPSG:4326"}).
}
\details{
For each feature - year combination, a separate request is made to the RAP
API, and results are returned as a combined \code{data.frame}. In the special case
of \code{year=NULL}) default all available years are returned in a single query.

For more information on the API and data products, see the RAP API
documentation: \url{https://rangelands.app/support/71-api-documentation}
}
\examples{
\dontshow{if (requireNamespace("terra") && isTRUE(as.logical(Sys.getenv("R_RAPR_EXTENDED_EXAMPLES", unset=FALSE)))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

aoi <- terra::vect(data.frame(x = -119.72330, y = 36.92204),
                   geom = c('x', 'y'),
                   crs = "EPSG:4326")

# all years (year=NULL)
res <- get_rap_production16day_table(aoi)
str(res)

# specific year
res <- get_rap_production16day_table(aoi, year = 1992)
str(res)

# multiple specific years
res <- get_rap_production16day_table(aoi, year = 1993:2003)
str(res)

# 1 kilometer buffer around point
res <- get_rap_production16day_table(terra::buffer(aoi, 1000), year = 2004)
str(res)
\dontshow{\}) # examplesIf}
}
