% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-diagnosis.R
\name{diagnose_filter}
\alias{diagnose_filter}
\title{Diagnose digital filter}
\usage{
diagnose_filter(
  b,
  a,
  fs,
  n = 512,
  whole = FALSE,
  sample = stats::rnorm(n, mean = sample_signal(n), sd = 0.2),
  vlines = NULL,
  xlim = "auto",
  cutoffs = c(-3, -6, -12)
)
}
\arguments{
\item{b}{the moving-average coefficients of an \code{ARMA} model}

\item{a}{the auto-regressive coefficients of an \code{ARMA} filter; default
is \code{1}}

\item{fs}{sampling frequency in \code{Hz}}

\item{n}{number of points at which to evaluate the frequency response;
default is \code{512}}

\item{whole}{whether to evaluate beyond \code{Nyquist} frequency; default
is false}

\item{sample}{sample signal of length \code{n} for simulation}

\item{vlines}{additional vertical lines (frequencies) to plot}

\item{xlim}{frequency limit of frequency response plot; default is
\code{"auto"}, can be \code{"full"} or a numeric of length 2}

\item{cutoffs}{cutoff decibel powers to draw on the frequency plot, also used
to calculate the frequency limit when \code{xlim} is \code{"auto"}}
}
\value{
Nothing
}
\description{
Generate frequency response plot with sample-data simulation
}
\examples{



library(ravetools)

# sample rate
srate <- 500

# signal length
npts <- 1000

# band-pass
bpass <- c(1, 50)

# Nyquist
fn <- srate / 2
w <- bpass / fn

# ---- FIR filter ------------------------------------------------
order <- 160

# FIR1 is MA filter, a = 1
filter <- fir1(order, w, "pass")

diagnose_filter(
  b = filter$b, a = filter$a, n = npts,
  fs = srate, vlines = bpass
)

# ---- Butter filter --------------------------------------------
filter <- butter(3, w, "pass")

diagnose_filter(
  b = filter$b, a = filter$a, n = npts,
  fs = srate, vlines = bpass
)



}
