% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_methods.R
\name{print.pool}
\alias{print.pool}
\title{Print Method for Pool Objects}
\usage{
\method{print}{pool}(x, digits = 2, ...)
}
\arguments{
\item{x}{An object of class \code{pool}, typically obtained from \code{\link[rbmi:pool]{rbmi::pool()}}.}

\item{digits}{Integer. Number of decimal places for rounding estimates,
standard errors, and confidence interval bounds. Default is 2.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the original pool object \code{x} (for pipe chaining).
}
\description{
Displays a formatted summary of a pooled analysis object from \code{\link[rbmi:pool]{rbmi::pool()}}.
Uses cli formatting to show rounded estimates, confidence intervals, parameter
labels, method information, number of imputations, and confidence level.
}
\details{
This method overrides \code{\link[rbmi:pool]{rbmi::print.pool()}} to provide enhanced, formatted
console output using the cli package. The override produces a
"Registered S3 method overwritten" message at package load time, which is
expected and harmless (same pattern as \code{\link[=print.analysis]{print.analysis()}}).

The output includes:
\itemize{
\item A header with parameter and visit counts
\item Metadata: pooling method, number of imputations, confidence level
\item A compact results table with key columns: parameter, visit, est, lci, uci, pval
}
}
\examples{
\donttest{
library(rbmi)
library(rbmiUtils)
data("ADMI")

ADMI$TRT <- factor(ADMI$TRT, levels = c("Placebo", "Drug A"))
ADMI$USUBJID <- factor(ADMI$USUBJID)
ADMI$AVISIT <- factor(ADMI$AVISIT)

vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
)
method <- method_bayes(n_samples = 20, control = control_bayes(warmup = 20))

ana_obj <- analyse_mi_data(ADMI, vars, method, fun = ancova)
pool_obj <- pool(ana_obj)
print(pool_obj)
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} for full tidy tibble output
\item \code{\link[=summary.pool]{summary.pool()}} for visit-level breakdown with significance flags
\item \code{\link[rbmi:pool]{rbmi::pool()}} to create pool objects
}
}
