% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_internal}
\alias{impute_internal}
\title{Create imputed datasets}
\usage{
impute_internal(
  draws,
  references = NULL,
  update_strategy,
  strategies,
  condmean
)
}
\arguments{
\item{draws}{A \code{draws} object created by \code{\link[=draws]{draws()}}.}

\item{references}{A named vector. Identifies the references to be used for reference-based
imputation methods. Should be of the form \code{c("Group1" = "Reference1", "Group2" = "Reference2")}.
If \code{NULL} (default), the references are assumed to be of the form
\code{c("Group1" = "Group1", "Group2" = "Group2")}. This argument cannot be \code{NULL} if
an imputation strategy (as defined by \code{data_ice[[vars$strategy]]} in the call to \link{draws}) other than \code{MAR} is set.}

\item{update_strategy}{An optional \code{data.frame}. Updates the imputation method that was
originally set via the \code{data_ice} option in \code{\link[=draws]{draws()}}. See the details section for more
information.}

\item{strategies}{A named list of functions. Defines the imputation functions to be used.
The names of the list should mirror the values specified in \code{strategy} column of \code{data_ice}.
Default = \code{\link[=getStrategies]{getStrategies()}}. See \code{\link[=getStrategies]{getStrategies()}} for more details.}

\item{condmean}{logical. If TRUE will impute using the conditional mean values, if values
will impute by taking a random draw from the multivariate normal distribution.}
}
\description{
This is the work horse function that implements most of the functionality of impute.
See the user level function \code{\link[=impute]{impute()}} for further details.
}
