% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pval_percentile}
\alias{pval_percentile}
\title{P-value of percentile bootstrap}
\usage{
pval_percentile(est)
}
\arguments{
\item{est}{a numeric vector of point estimates from each bootstrap sample.}
}
\value{
A named numeric vector of length 2 containing the p-value for H_0: theta=0 vs H_A: theta>0
(\code{"pval_greater"}) and the p-value for H_0: theta=0 vs H_A: theta<0 (\code{"pval_less"}).
}
\description{
Determines the (not necessarily unique) quantile (type=6) of "est" which gives a value of 0
From this, derive the p-value corresponding to the percentile bootstrap via inversion.
}
\details{
The p-value for H_0: theta=0 vs H_A: theta>0 is the value \code{alpha} for which \code{q_alpha = 0}.
If there is at least one estimate equal to zero it returns the largest \code{alpha} such that \code{q_alpha = 0}.
If all bootstrap estimates are > 0 it returns 0; if all bootstrap estimates are < 0 it returns 1. Analogous
reasoning is applied for the p-value for H_0: theta=0 vs H_A: theta<0.
}
