% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.RWDRI}
\alias{plot.RWDRI}
\title{Standard plot method for objects of class 'RWDRI'}
\usage{
\method{plot}{RWDRI}(
  x,
  Scale = c("original", "transformed", "zScore"),
  RIperc = c(0.025, 0.975),
  Nhist = 60,
  showMargin = TRUE,
  showPathol = FALSE,
  scalePathol = TRUE,
  showBSModels = FALSE,
  showValue = TRUE,
  uncertaintyRegion = c("bootstrapCI", "uncertaintyMargin"),
  CIprop = 0.95,
  UMprop = 0.9,
  pointEst = c("fullDataEst", "medianBS"),
  colScheme = c("green", "blue"),
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{(object) of class 'RWDRI'}

\item{Scale}{(character) specifying if percentiles are shown on the original scale ("or") or the transformed scale ("tr") or the z-Score scale ("z")}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}

\item{Nhist}{(integer) number of bins in the histogram (derived automatically if not set)}

\item{showMargin}{(logical) specifying if the specified margins, i.e. confidence intervals or uncertainty margins, shall be shown}

\item{showPathol}{(logical) specifying if the estimated pathological distribution shall be shown}

\item{scalePathol}{(logical) specifying if the estimated pathological distribution shall be weighted with the ration of pathol/non-pathol}

\item{showBSModels}{(logical) specifying if the estimated bootstrapping models shall be shown}

\item{showValue}{(logical) specifying if the exact value of the estimated reference intervals shall be shown above the plot}

\item{uncertaintyRegion}{(character) specifying the type of the uncertainty region around point estimates}

\item{CIprop}{(numeric) value specifying the central region for estimation of confidence intervals}

\item{UMprop}{(numeric) value specifying the central region for estimation of uncertainty margins}

\item{pointEst}{(character) specifying the point estimate determination: (1) using the full dataset ("fullDataEst"),
(2) calculating the median model from the bootstrap samples ("medianBS"), (2) works only if NBootstrap > 0}

\item{colScheme}{(character) specifying color scheme of the non-pathological distribution and reference interval; choices are "green" and "blue"}

\item{xlim}{(numeric) vector specifying the limits in x-direction}

\item{ylim}{(numeric) vector specifying the limits in y-direction}

\item{xlab}{(character) specifying the x-axis label}

\item{ylab}{(character) specifying the y-axis label}

\item{title}{(character) specifying plot title}

\item{...}{additional arguments passed forward to other functions}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{			The applied plot limits in x-direction (xlim) are returned.
}\if{html}{\out{</div>}}
}
\description{
Standard plot method for objects of class 'RWDRI'
}
\author{
Christopher Rank \email{christopher.rank@roche.com}, Tatjana Ammer \email{tatjana.ammer@roche.com}
}
