% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specta_data_processing.R
\name{compute_sea_state_2d_spectrum}
\alias{compute_sea_state_2d_spectrum}
\title{Compute sea_state parameter from wave directional spectrum}
\usage{
compute_sea_state_2d_spectrum(spec, ...)
}
\arguments{
\item{spec}{2D spectrum data, e.g. from \code{get_2Dspectrum}}

\item{...}{currently unused}
}
\value{
a tibble with the sea-state parameters computed from the time series of 2D spectrum
}
\description{
Compute sea_state parameter from wave directional spectrum
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) withAutoprint(\{ # examplesIf}
rscd_params <- get_parameters(
  node = "134865",
  start = "1994-01-01",
  end = "1994-01-31 23:00:00",
  parameters = c("hs", "tp")
)
spec <- resourcecodedata::rscd_2d_spectra
param_calc <- compute_sea_state_2d_spectrum(spec)
oldpar <- par(mfcol = c(2, 1))
plot(param_calc$time, param_calc$hs, type = "l", xlab = "Time", ylab = "Hs (m)")
lines(rscd_params$time, rscd_params$hs, col = "red")
plot(param_calc$time, param_calc$tp, type = "l", xlab = "Time", ylab = "Tp (s)")
lines(rscd_params$time, rscd_params$tp, col = "red")
par(oldpar)
\dontshow{\}) # examplesIf}
}
