/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.scalarfield;

import usf.saav.scalarfield.ScalarField2D;

public abstract class Synthetic2D
extends ScalarField2D.Default {
    int width;
    int height;

    public Synthetic2D(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static class GaussianMixing
    extends Synthetic2D {
        int[] px;
        int[] py;
        double[] A;

        public GaussianMixing(int n, int n2) {
            super(n, n2);
            this.px = new int[]{n / 3 + 10, n * 2 / 3 - 10, n / 3 - 10, n * 2 / 3 + 10};
            this.py = new int[]{n2 / 3 - 10, n2 * 2 / 3 + 10, n2 * 2 / 3 + 10, n2 / 3 - 10};
            this.A = new double[]{70.0, 50.0, -40.0, -20.0};
        }

        @Override
        public float getValue(int n, int n2) {
            double d = 0.0;
            double d2 = 60.0;
            double d3 = 60.0;
            for (int i = 0; i < this.px.length; ++i) {
                double d4 = n - this.px[i];
                double d5 = n2 - this.py[i];
                d += this.A[i] * Math.exp(-(d4 * d4) / (2.0 * d2 * d2) - d5 * d5 / (2.0 * d3 * d3));
            }
            return (float)d;
        }
    }

    public static class MonkeySaddle
    extends Synthetic2D {
        public MonkeySaddle(int n, int n2) {
            super(n, n2);
        }

        @Override
        public float getValue(int n, int n2) {
            double d = ((double)n - (double)(this.width / 2)) / 100.0;
            double d2 = ((double)n2 - (double)(this.height / 2)) / 100.0;
            return (float)(d * d * d - 3.0 * d * (d2 * d2)) + (float)(d / 100.0 + d2 / 100.0);
        }
    }
}

