/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.reebgraph;

import java.util.ArrayList;
import usf.saav.topology.TopoGraph;
import usf.saav.topology.TopoTreeNode;

public class ReebGraphVertex
implements TopoGraph.Vertex,
TopoTreeNode {
    private float val;
    private int idx;
    private int gid;
    private float realVal;
    private ReebGraphVertex topoPartner;
    public ArrayList<ReebGraphVertex> neighbors = new ArrayList();

    public ReebGraphVertex(float f, float f2, int n) {
        this.val = f;
        this.gid = n;
        this.realVal = f2;
    }

    public String toString() {
        return this.getGlobalID() + "/" + this.idx + " (" + this.getRealValue() + "/" + this.value() + ")";
    }

    @Override
    public TopoGraph.Vertex[] neighbors() {
        return this.neighbors.toArray(new TopoGraph.Vertex[this.neighbors.size()]);
    }

    @Override
    public float value() {
        return this.val;
    }

    @Override
    public int getID() {
        return this.idx;
    }

    public void setID(int n) {
        this.idx = n;
    }

    public int getGlobalID() {
        return this.gid;
    }

    public float getRealValue() {
        return this.realVal;
    }

    public void setValue(float f) {
        this.val = f;
    }

    @Override
    public TopoTreeNode.NodeType getType() {
        int n = 0;
        int n2 = 0;
        for (ReebGraphVertex reebGraphVertex : this.neighbors) {
            if (this.value() < reebGraphVertex.value()) {
                ++n;
            }
            if (!(this.value() > reebGraphVertex.value())) continue;
            ++n2;
        }
        if (n == 0) {
            return TopoTreeNode.NodeType.LEAF_MAX;
        }
        if (n2 == 0) {
            return TopoTreeNode.NodeType.LEAF_MIN;
        }
        if (n == 2) {
            return TopoTreeNode.NodeType.UPFORK;
        }
        if (n2 == 2) {
            return TopoTreeNode.NodeType.DOWNFORK;
        }
        return null;
    }

    public void addNeighbor(ReebGraphVertex reebGraphVertex) {
        this.neighbors.add(reebGraphVertex);
    }

    public static void setNeighbors(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
        reebGraphVertex.addNeighbor(reebGraphVertex2);
        reebGraphVertex2.addNeighbor(reebGraphVertex);
    }

    @Override
    public TopoTreeNode getPartner() {
        return this.topoPartner;
    }

    public void setPartner(ReebGraphVertex reebGraphVertex) {
        this.topoPartner = reebGraphVertex;
    }

    public boolean isEssential() {
        return this.getType() == TopoTreeNode.NodeType.DOWNFORK && this.topoPartner.getType() == TopoTreeNode.NodeType.UPFORK || this.getType() == TopoTreeNode.NodeType.UPFORK && this.topoPartner.getType() == TopoTreeNode.NodeType.DOWNFORK;
    }

    @Override
    public float getBirth() {
        if (this.topoPartner == null) {
            return this.value();
        }
        if (this.isEssential()) {
            return Math.max(this.value(), this.topoPartner.value());
        }
        return Math.min(this.value(), this.topoPartner.value());
    }

    @Override
    public float getDeath() {
        if (this.topoPartner == null) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.isEssential()) {
            return Math.min(this.value(), this.topoPartner.value());
        }
        return Math.max(this.value(), this.topoPartner.value());
    }

    @Override
    public float getPersistence() {
        return this.getDeath() - this.getBirth();
    }

    @Override
    public float getValue() {
        return this.val;
    }
}

