#' Generate a Rscript with its skeleton
#'
#' @param file Output file. Use `file=stdout()` to write the output to standard output.
#'
#' @return Invisibly returns the character vector of skeleton lines.
#'   Called for its side effect of writing to \code{file}.
#' @export
#' @examples
#' scriptSkeleton(file = file.path(tempdir(), "myscript.R"))

scriptSkeleton <- function(file) {
    sentences <- c("#!/usr/bin/env Rscript",
                   "",
                   "# Initialize the script",
                   "suppressMessages(library(ribiosArg))",
                   "ribiosArg::scriptInit()",
                   "usage <- paste(\"Usage:\", scriptName(), \" USAGES\\nUsage Details\", sep=\"\")",
                   "argParse(\"log,1\", \
                     \"Param1 Param2\", usage)",
                   "",
                   "# Create log",
                   "logfile <- argGet(\"log\", default=NULL)",
                   "registerLog(logfile)",
                   "doLog(\"%s starts\", scriptName())",
                   "",
                   "# Library loading",
                   "doLog(\"Library loading\")",
                   "libordie(ribiosBase)",
                   "",
                   "# Program logic goes here",
                   "",
                   "",
                   "# Quit",
                   "doLog(\"%s quits\", scriptName())",
                   "qqmsg(status=0L)",
                   sep="\n")
    if(!missing(file)) {
        writeLines(text=sentences, con=file, sep="\n")
    }
    return(invisible(sentences))
}
