% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFuncs.R
\name{parseNumVec}
\alias{parseNumVec}
\title{Parse a character string into a numveric vector}
\usage{
parseNumVec(str, expLen = 2, failVal = c(5, 5), sep = ",")
}
\arguments{
\item{str}{A character string}

\item{expLen}{Integer or \code{NULL}, Expected length of the numeric vector.  When set to NULL, the numeric vector can be of variable length.}

\item{failVal}{If the parsing failed (for example length not correct, or non-numeric values were provided, this value will be returned}

\item{sep}{Separator in the character string, default ","}
}
\value{
A numeric vector of the parsed values, or \code{failVal} if parsing fails.
}
\description{
Numeric vectors can be given as arguments in two ways: (1) separated by
blanks or (2) separated by other common separators, such as comma
(,). This function parses a string, or a string vector into a numeric
vector of expected length. In addition it is failure safe: user can
specify the return value in case the parsing was not successful,
}
\details{
The input value mostly comes from return values of the \code{\link{argGet}} function.
}
\examples{
parseNumVec("3,7,9", expLen=3)
}
\seealso{
\code{\link{argGet}}
}
