% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportGML.R
\name{exportGML}
\alias{exportGML}
\title{Export igraph object to GML, friendly to Cytoscape and yEd}
\usage{
exportGML(igraph, filename)
}
\arguments{
\item{igraph}{An \code{igraph} object}

\item{filename}{Filename}
}
\value{
Invisible NULL
}
\description{
\code{exportGML} exports an \code{igraph} object to GML files
complying with specifications defined by Cytoscape and yEd. Compared
 to the native \code{write.graph} function provided by the
 \code{igraph} package, GML files exported with \code{exportGML} can be
 directly read and properly visualized by Cytoscape and yEd.

  Currently the function uses supports following attributes:
 Node name: \code{V(igraph)$name}
 Node label: \code{V(igraph)$label}
 Node isInput: \code{V(igraph)$isInput}, controlling node shapes
 Edge label: \code{V(igraph)$label}, determining edge target arrow
   
 So far the function is mainly used by the \code{ronet.Rscript} script
 in the package. Users are invited to adapt the function for other purposes.
}
\examples{
 g <- barabasi.game(100, directed=FALSE)
 V(g)$label <- c(paste("node", 1:99, sep=""),"--")
 V(g)$name <- 1:100 
 V(g)$isInput <- rbinom(100,1, 0.5)
 E(g)$label <- "Expression"
 gPosE <- as.logical(rbinom(ecount(g), 1, 0.25))
 gNegE <- as.logical(rbinom(ecount(g), 1, 0.25))
 E(g)$label[gPosE] <- "Expressoion_Positive"
 E(g)$label[gNegE] <- "Expressoion_Negative"
 gFile <- tempfile()
 exportGML(g, gFile)

}
\seealso{
\code{\link[igraph]{write.graph}}
}
\author{
Jitao David Zhang, \email{jitao_david.zhang@roche.com}
}
