% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{age.range}
\alias{age.range}
\title{Calculate age ranges}
\usage{
age.range(calib, prob = 0.95, roundby = 0, BCAD = FALSE)
}
\arguments{
\item{calib}{The calibrated distribution, as returned from caldist()}

\item{prob}{Probability range which should be calculated. Default \code{prob=0.95}.}

\item{roundby}{Rounding. Defaults to 0 decimals.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}
}
\value{
The highest posterior density ranges, as three columns: from age, to age, and the corresponding percentage(s) of the range(s)
}
\description{
Calculate the quantile age ranges of a calibrated distribution
}
\examples{
age.range(caldist(130,20, bombalert=FALSE))
}
