/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceLoader;
import jdplus.toolkit.base.tsp.DataSourceProvider;
import jdplus.toolkit.base.tsp.FileLoader;
import jdplus.toolkit.base.tsp.fixme.Files2;
import lombok.NonNull;

public interface DataSourceFactory
extends TsFactory {
    @NonNull
    default public <T extends DataSourceProvider> Optional<T> getProvider(@NonNull Class<T> type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getProvider(name).filter(type::isInstance).map(type::cast);
    }

    @NonNull
    default public <T extends DataSourceProvider> Optional<T> getProvider(@NonNull Class<T> type, @NonNull DataSource dataSource) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return this.getProvider(type, dataSource.getProviderName());
    }

    @NonNull
    default public <T extends DataSourceProvider> Optional<T> getProvider(@NonNull Class<T> type, @NonNull DataSet dataSet) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        return this.getProvider(type, dataSet.getDataSource());
    }

    @NonNull
    default public <T extends DataSourceProvider> Optional<T> getProvider(@NonNull Class<T> type, @NonNull TsMoniker moniker) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        return this.getProvider(type, moniker.getSource());
    }

    @NonNull
    default public Optional<File> getFile(@NonNull DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return this.getProvider(FileLoader.class, dataSource).map(loader -> {
            File file = loader.decodeBean(dataSource).getFile();
            return Files2.getAbsoluteFile(loader.getPaths(), file);
        });
    }

    @NonNull
    default public Optional<TsCollection> getTsCollection(@NonNull DataSource dataSource, @NonNull TsInformationType info) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.getProvider(DataSourceProvider.class, dataSource).map(provider -> {
            TsMoniker moniker = provider.toMoniker(dataSource);
            try {
                return provider.getTsCollection(moniker, info);
            }
            catch (IOException ex) {
                return this.makeTsCollection(moniker, ex);
            }
        });
    }

    @NonNull
    default public Optional<TsCollection> getTsCollection(@NonNull DataSet dataSet, @NonNull TsInformationType info) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.getProvider(DataSourceProvider.class, dataSet).map(provider -> {
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    TsMoniker moniker = provider.toMoniker(dataSet);
                    try {
                        return provider.getTsCollection(moniker, info);
                    }
                    catch (IOException ex) {
                        return this.makeTsCollection(moniker, ex);
                    }
                }
                case SERIES: {
                    TsMoniker moniker = provider.toMoniker(dataSet);
                    try {
                        return TsCollection.of((Ts)provider.getTs(moniker, info));
                    }
                    catch (IOException ex) {
                        return TsCollection.of((Ts)this.makeTs(moniker, ex));
                    }
                }
                case DUMMY: {
                    return TsCollection.builder().name(provider.getDisplayName(dataSet)).build();
                }
            }
            throw new RuntimeException("Not implemented");
        });
    }

    @NonNull
    default public Optional<Ts> getTs(@NonNull DataSet dataSet, @NonNull TsInformationType info) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.getProvider(DataSourceProvider.class, dataSet).map(provider -> {
            if (dataSet.getKind() == DataSet.Kind.SERIES) {
                TsMoniker moniker = provider.toMoniker(dataSet);
                try {
                    return provider.getTs(moniker, info);
                }
                catch (IOException ex) {
                    return this.makeTs(moniker, ex);
                }
            }
            throw new RuntimeException("Not implemented");
        });
    }

    default public boolean open(@NonNull DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return this.getProvider(DataSourceLoader.class, dataSource.getProviderName()).map(loader -> loader.open(dataSource)).orElse(false);
    }
}

