/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.stats.StatException;
import lombok.Generated;
import lombok.NonNull;

public final class StatUtility {
    public static double theilInequalityCoefficient(DoubleSeq a, DoubleSeq b) {
        int n = a.length();
        if (b.length() != n) {
            throw new StatException("Non compatible data");
        }
        double dssq = 0.0;
        double assq = 0.0;
        double bssq = 0.0;
        DoubleSeqCursor acur = a.cursor();
        DoubleSeqCursor bcur = b.cursor();
        for (int i = 0; i < n; ++i) {
            double ca = acur.getAndNext();
            double cb = bcur.getAndNext();
            assq += ca * ca;
            bssq += cb * cb;
            double del = ca - cb;
            dssq += del * del;
        }
        if (dssq == 0.0) {
            return 0.0;
        }
        return Math.sqrt(dssq /= (double)n) / (Math.sqrt(assq /= (double)n) + Math.sqrt(bssq /= (double)n));
    }

    public static double theilInequalityCoefficient2(@NonNull DoubleSeq a, @NonNull DoubleSeq b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        int n = a.length();
        if (b.length() != n) {
            throw new StatException("Non compatible data");
        }
        if (a.anyMatch(d -> d == 0.0)) {
            return Double.NaN;
        }
        if (a.isEmpty() || b.isEmpty()) {
            throw new StatException("a and b cannot be empty");
        }
        double nssq = 0.0;
        double dssq = 0.0;
        DoubleSeqCursor atcur = a.cursor();
        DoubleSeqCursor at1cur = a.cursor();
        DoubleSeqCursor bt1cur = b.cursor();
        at1cur.skip(1);
        bt1cur.skip(1);
        for (int i = 0; i < n - 1; ++i) {
            double cat1 = at1cur.getAndNext();
            double cbt1 = bt1cur.getAndNext();
            double cat = atcur.getAndNext();
            double rn = cbt1 - cat1;
            nssq += (rn /= cat) * rn;
            double rd = cat1 - cat;
            dssq += (rd /= cat) * rd;
        }
        if (dssq == 0.0) {
            return 0.0;
        }
        return Math.sqrt(nssq) / Math.sqrt(dssq);
    }

    @Generated
    private StatUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

